#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;

bool second_over(int n, ll k, const vector<ll>& pf, int ind){
    int l = ind+1;
    int r = n-1;
    int mid;

    while(l<=r){
        mid = (l+r)/2;
        if(pf[mid] - pf[ind] > k){
            r = mid - 1;
        }
        else if(pf[mid] - pf[ind] > pf[ind]){
            return true;
        }
        else{
            l = mid + 1;
        }
    }

    return false;
}

bool solve(int n, ll k, const vector<ll>& d){
    vector<ll> pf(n);
    for(int i=0; i<n; ++i){
        pf[i] = (i==0 ? 0ll : pf[i-1]) + d[i];
    }

    
    for(int i=0; i<n && pf[i]<=k; ++i){
        if(!second_over(n, k, pf, i)) return true;   
    }

    return false;
}

int main(){
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    int t; cin >> t;
    while(t--){
        int n; cin >> n;
        ll k; cin >> k;
        vector<ll> d(n);
        for(int i=0; i<n; ++i) cin >> d[i];

        cout << (solve(n, k, d) ? "da\n" : "ne\n");
    }
}